import glob
from dag_core import check_param
    
def get_samples(fastqDir):
    SAMPLES = glob.glob('{}*.fq.gz'.format(fastqDir))
    SAMPLES = [sample.replace('{}'.format(fastqDir),'').replace('.fq.gz','') for sample in SAMPLES]
    sample_file = open('.sample.list','w')
    for sample in SAMPLES:
        sample_file.write("%s\n" % sample)
    sample_file.close()
    return(SAMPLES)

def get_trim_galore_args(tg_params):

    # check provided parameter types look ok
    for param in ('trim_length','trim_qual', 'stringency', 'max_n', 'clip_5prime', 'clip_3prime'):
        check_param(tg_params, param, int)
        
    for param in ('encoding','adapter'):
        check_param(tg_params, param, str)

    for param in ('run_trimming','trim_n'):
        check_param(tg_params, param, bool)

    check_param(tg_params,'error_rate',float)

    encodings=('phred33','phred64')
    assert tg_params['encoding'] in encodings, \
        'Invalid quality encoding specified: %s' % tg_parms['encoding']

    adapters=('auto','illumina','nextera','small_rna')
    assert tg_params['adapter'] in adapters, 'Invalid adapter specified: %s' % tg_params['adapter']

    trim_galore_args="--length %i -q %i --stringency %i -e %f --max_n %i " \
        % (tg_params['trim_length'], tg_params['trim_qual'],tg_params['stringency'], \
           tg_params['error_rate'], tg_params['max_n'])

    if tg_params['clip_5prime'] > 0:
        trim_galore_args+=' --clip_R1 %i' % tg_params['clip_5prime']

    if tg_params['clip_3prime'] > 0:
        trim_galore_args+=' --three_prime_clip_R1 %i' % tg_params['clip_3prime']

    if len(tg_params['adapter_seq']):
        assert re.match('^[ACTG]+$',tg_params['adapter_seq']), \
            'Invalid adapter sequence provided: %s' % tg_params['adapter_seq']
        trim_galore_args+=' -a %s' % tg_params['adapter_seq']
    else:
        if tg_params['adapter'] == 'illumina':
            trim_galore_args += ' --illumina'
        elif tg_params['adapter'] == 'nextera':
            trim_galore_args += ' --nextera'
        elif tg_params['adapter'] == 'small_rna':
            trim_galore_args += ' --small_rna'

    if tg_params['encoding'] == 'phred64':
        # default is phred33
        trim_galore_args += ' --phred64'

    if tg_params['trim_n']:
        trim_galore_args += ' --trim-n'

    return(trim_galore_args)
