import subprocess
import pickle

def check_param(tg_params,param,p_type):
    assert isinstance(tg_params[param],p_type), \
    'Invalid parameter value defined for %s (%s)' % (param,tg_params[param])
    
def get_jobname():
    jobname_file = open('.jobname','r')
    JOBNAME=jobname_file.readline().rstrip("\n")
    jobname_file.close()
    return(JOBNAME)    

def pickle_params(tg_params,param_file):
    args_file = open(param_file,'wb')
    pkl=pickle.dumps(tg_params)
    args_file.write(pkl)
    args_file.close()

def export_environment():
    environment = subprocess.run(['conda','env','export'],stdout=subprocess.PIPE)
    env_file=open('conda_environment.yaml','w')
    env_file.write(environment.stdout.decode('UTF-8'))
    env_file.close()
    return()